/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateNodeResponse;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigUnavailableException;
import com.floragunn.searchguard.configuration.ConfigurationLoader;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.Hideable;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.StaticDefinable;
import com.floragunn.searchguard.configuration.StaticSgConfig;
import com.floragunn.searchguard.dlic.rest.api.Endpoint;
import com.floragunn.searchguard.dlic.rest.api.RestApiPrivilegesEvaluator;
import com.floragunn.searchguard.dlic.rest.validation.AbstractConfigurationValidator;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchguard.user.UserInformation;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public abstract class AbstractApiAction
extends BaseRestHandler {
    protected final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected final ConfigurationRepository cl;
    protected final ClusterService cs;
    final ThreadPool threadPool;
    private final RestApiPrivilegesEvaluator restApiPrivilegesEvaluator;
    protected final Boolean acceptInvalidLicense;
    protected final AuditLog auditLog;
    protected final Settings settings;
    protected final StaticSgConfig staticSgConfig;
    private final ConfigurationLoader configLoader;

    protected AbstractApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, StaticSgConfig staticSgConfig, ClusterService cs, PrincipalExtractor principalExtractor, AuthorizationService authorizationService, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, ThreadPool threadPool, AuditLog auditLog) {
        this.settings = settings;
        this.acceptInvalidLicense = settings.getAsBoolean("searchguard.unsupported.restapi.accept_invalid_license", Boolean.FALSE);
        this.cl = cl;
        this.cs = cs;
        this.threadPool = threadPool;
        this.restApiPrivilegesEvaluator = new RestApiPrivilegesEvaluator(settings, adminDNs, authorizationService, specialPrivilegesEvaluationContextProviderRegistry, principalExtractor, configPath, threadPool);
        this.auditLog = auditLog;
        this.staticSgConfig = staticSgConfig;
        this.configLoader = new ConfigurationLoader(client, cl);
    }

    protected abstract AbstractConfigurationValidator getValidator(RestRequest var1, BytesReference var2, Object ... var3);

    protected abstract String getResourceName();

    protected abstract CType<?> getConfigName();

    protected void handleApiRequest(RestChannel channel, RestRequest request, Client client) throws IOException {
        AbstractConfigurationValidator validator = this.getValidator(request, request.content(), new Object[0]);
        if (!validator.validate()) {
            request.params().clear();
            this.badRequestResponse(channel, validator);
            return;
        }
        switch (request.method()) {
            case DELETE: {
                this.handleDelete(channel, request, client, validator.getContentAsNode());
                break;
            }
            case POST: {
                this.handlePost(channel, request, client, validator.getContentAsNode());
                break;
            }
            case PUT: {
                this.handlePut(channel, request, client, validator.getContentAsNode());
                break;
            }
            case GET: {
                this.handleGet(channel, request, client, validator.getContentAsNode());
                break;
            }
            default: {
                this.badRequestResponse(channel, request.method() + " not supported for " + this.getName());
            }
        }
    }

    protected void handleDelete(final RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        SgDynamicConfiguration existingConfiguration;
        final String name = request.param("name");
        if (name == null || name.length() == 0) {
            this.badRequestResponse(channel, "No " + this.getResourceName() + " specified.");
            return;
        }
        try {
            existingConfiguration = this.load(this.getConfigName(), false);
        }
        catch (ConfigUnavailableException e) {
            this.internalErrorResponse(channel, e.getMessage());
            return;
        }
        if (this.isHidden(existingConfiguration, name)) {
            this.notFound(channel, this.getResourceName() + " " + name + " not found.");
            return;
        }
        if (this.isReserved(existingConfiguration, name)) {
            this.forbidden(channel, "Resource '" + name + "' is read-only.");
            return;
        }
        boolean existed = existingConfiguration.exists(name);
        existingConfiguration = existingConfiguration.without(name);
        if (existed) {
            this.saveAnUpdateConfigs(client, request, this.getConfigName(), existingConfiguration, new OnSucessActionListener<IndexResponse>(channel){

                public void onResponse(IndexResponse response) {
                    AbstractApiAction.this.successResponse(channel, "'" + name + "' deleted.");
                }
            });
        } else {
            this.notFound(channel, this.getResourceName() + " " + name + " not found.");
        }
    }

    protected void handlePut(final String name, final RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        SgDynamicConfiguration existingConfiguration;
        try {
            existingConfiguration = this.load(this.getConfigName(), false);
        }
        catch (ConfigUnavailableException e) {
            this.internalErrorResponse(channel, e.getMessage());
            return;
        }
        if (this.isHidden(existingConfiguration, name)) {
            this.forbidden(channel, "Resource '" + name + "' is not available.");
            return;
        }
        if (this.isReserved(existingConfiguration, name)) {
            this.forbidden(channel, "Resource '" + name + "' is read-only.");
            return;
        }
        if (this.log.isTraceEnabled() && content != null) {
            this.log.trace(content.toString());
        }
        final boolean existed = existingConfiguration.exists(name);
        Parser.ReturningValidationResult parser = this.getConfigName().getParser();
        ValidationResult validatedConfig = parser.parse(content, (Parser.Context)this.cl.getParserContext());
        try {
            existingConfiguration = existingConfiguration.with(name, validatedConfig.get());
        }
        catch (ConfigValidationException e) {
            this.badRequestResponse(channel, e.toJsonString());
            return;
        }
        this.saveAnUpdateConfigs(client, request, this.getConfigName(), existingConfiguration, new OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse response) {
                if (existed) {
                    AbstractApiAction.this.successResponse(channel, "'" + name + "' updated.");
                } else {
                    AbstractApiAction.this.createdResponse(channel, "'" + name + "' created.");
                }
            }
        });
    }

    protected void handlePut(RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        String name = request.param("name");
        if (name == null || name.length() == 0) {
            this.badRequestResponse(channel, "No " + this.getResourceName() + " specified.");
            return;
        }
        this.handlePut(name, channel, request, client, content);
    }

    protected void handlePost(RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.POST);
    }

    protected void handleGet(RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        String resourcename = request.param("name");
        try {
            SgDynamicConfiguration configuration;
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                configuration = this.configLoader.loadSync(this.getConfigName(), "API Request");
            }
            this.logComplianceEvent(configuration);
            configuration = this.filter(configuration);
            if (resourcename == null || resourcename.length() == 0) {
                configuration = this.staticSgConfig.addTo(configuration);
                this.successResponse(channel, configuration);
                return;
            }
            if (!configuration.exists(resourcename)) {
                this.notFound(channel, "Resource '" + resourcename + "' not found.");
                return;
            }
            configuration = configuration.only(resourcename);
            this.successResponse(channel, configuration);
        }
        catch (ConfigUnavailableException e) {
            this.log.error("Error while loading configuration", (Throwable)e);
            this.internalErrorResponse(channel, e.getMessage());
        }
    }

    protected final <T> SgDynamicConfiguration<T> load(CType<T> config, boolean logComplianceEvent) throws ConfigUnavailableException {
        SgDynamicConfiguration loaded;
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            loaded = this.cl.getConfigurationFromIndex(config, "API Request");
        }
        if (logComplianceEvent) {
            this.logComplianceEvent(loaded);
        }
        loaded = this.staticSgConfig.addTo(loaded);
        return loaded;
    }

    protected boolean ensureIndexExists() {
        return this.cl.isIndexInitialized();
    }

    protected SgDynamicConfiguration<?> filter(SgDynamicConfiguration<?> builder) {
        return builder.withoutHidden();
    }

    protected void saveAnUpdateConfigs(Client client, RestRequest request, CType<?> cType, SgDynamicConfiguration<?> configuration, OnSucessActionListener<IndexResponse> actionListener) {
        String searchGuardIndex = this.cl.getEffectiveSearchGuardIndex();
        if (searchGuardIndex == null) {
            throw new RuntimeException("The Search Guard index has not yet been created");
        }
        IndexRequest ir = new IndexRequest(searchGuardIndex);
        String id = cType.toLCString();
        configuration = configuration.withoutStatic();
        try {
            client.index(((IndexRequest)ir.id(id).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setIfSeqNo(configuration.getSeqNo()).setIfPrimaryTerm(configuration.getPrimaryTerm()).source(new Object[]{id, XContentHelper.toXContent((ToXContent)configuration, (XContentType)XContentType.JSON, (boolean)false)}), new ConfigUpdatingActionListener<IndexResponse>(client, actionListener));
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        this.consumeParameters(request);
        request.content();
        if (!this.ensureIndexExists()) {
            return channel -> this.internalErrorResponse((RestChannel)channel, AbstractConfigurationValidator.ErrorType.SG_NOT_INITIALIZED.getMessage());
        }
        String authError = this.restApiPrivilegesEvaluator.checkAccessPermissions(request, this.getEndpoint());
        if (authError != null) {
            this.log.error("No permission to access REST API: " + authError);
            User user = (User)this.threadPool.getThreadContext().getTransient("_sg_user");
            this.auditLog.logMissingPrivileges(authError, (UserInformation)user, request);
            request.params().clear();
            return channel -> this.forbidden((RestChannel)channel, "No permission to access REST API: " + authError);
        }
        Object originalUser = this.threadPool.getThreadContext().getTransient("_sg_user");
        Object originalRemoteAddress = this.threadPool.getThreadContext().getTransient("_sg_remote_address");
        Object originalOrigin = this.threadPool.getThreadContext().getTransient("_sg_origin");
        return channel -> this.threadPool.generic().submit(() -> {
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                this.threadPool.getThreadContext().putHeader("_sg_conf_request", "true");
                this.threadPool.getThreadContext().putTransient("_sg_user", originalUser);
                this.threadPool.getThreadContext().putTransient("_sg_remote_address", originalRemoteAddress);
                this.threadPool.getThreadContext().putTransient("_sg_origin", originalOrigin);
                this.handleApiRequest((RestChannel)channel, request, (Client)client);
            }
            catch (Exception e) {
                this.log.error("Error while processing request " + request, (Throwable)e);
                this.internalErrorResponse((RestChannel)channel, "Error while processing request: " + e);
            }
        });
    }

    protected boolean checkConfigUpdateResponse(ConfigUpdateResponse response) {
        boolean success;
        int nodeCount = this.cs.state().getNodes().getNodes().size();
        boolean expectedConfigCount = true;
        boolean bl = success = response.getNodes().size() == nodeCount;
        if (!success) {
            this.log.error("Expected " + nodeCount + " nodes to return response, but got only " + response.getNodes().size());
        }
        for (String nodeId : response.getNodesMap().keySet()) {
            boolean successNode;
            ConfigUpdateNodeResponse node = (ConfigUpdateNodeResponse)response.getNodesMap().get(nodeId);
            boolean bl2 = successNode = node.getUpdatedConfigTypes() != null && node.getUpdatedConfigTypes().length == 1;
            if (!successNode) {
                this.log.error("Expected 1 config types for node " + nodeId + " but got only " + Arrays.toString(node.getUpdatedConfigTypes()));
            }
            success = success && successNode;
        }
        return success;
    }

    protected static XContentBuilder convertToJson(RestChannel channel, ToXContent toxContent) {
        try {
            XContentBuilder builder = channel.newBuilder();
            toxContent.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return builder;
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    protected void response(RestChannel channel, RestStatus status, String message) {
        try {
            XContentBuilder builder = channel.newBuilder();
            builder.startObject();
            builder.field("status", status.name());
            builder.field("message", message);
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(status, builder));
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    protected void successResponse(RestChannel channel, SgDynamicConfiguration<?> response) {
        try {
            XContentBuilder builder = channel.newBuilder();
            builder.value(response.toRedactedLegacyBasicObject());
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    protected void badRequestResponse(RestChannel channel, AbstractConfigurationValidator validator) {
        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, validator.errorsAsXContent(channel)));
    }

    protected void successResponse(RestChannel channel, String message) {
        this.response(channel, RestStatus.OK, message);
    }

    protected void createdResponse(RestChannel channel, String message) {
        this.response(channel, RestStatus.CREATED, message);
    }

    protected void badRequestResponse(RestChannel channel, String message) {
        this.response(channel, RestStatus.BAD_REQUEST, message);
    }

    protected void notFound(RestChannel channel, String message) {
        this.response(channel, RestStatus.NOT_FOUND, message);
    }

    protected void forbidden(RestChannel channel, String message) {
        this.response(channel, RestStatus.FORBIDDEN, message);
    }

    protected void internalErrorResponse(RestChannel channel, String message) {
        this.response(channel, RestStatus.INTERNAL_SERVER_ERROR, message);
    }

    protected void unprocessable(RestChannel channel, String message) {
        this.response(channel, RestStatus.UNPROCESSABLE_ENTITY, message);
    }

    protected void notImplemented(RestChannel channel, RestRequest.Method method) {
        this.response(channel, RestStatus.NOT_IMPLEMENTED, "Method " + method.name() + " not supported for this action.");
    }

    protected final boolean isReserved(SgDynamicConfiguration<?> configuration, String resourceName) {
        if (this.isStatic(configuration, resourceName)) {
            return true;
        }
        Object o = configuration.getCEntry(resourceName);
        return o != null && o instanceof Hideable && ((Hideable)o).isReserved();
    }

    protected final boolean isHidden(SgDynamicConfiguration<?> configuration, String resourceName) {
        Object o = configuration.getCEntry(resourceName);
        return o != null && o instanceof Hideable && ((Hideable)o).isHidden();
    }

    protected final boolean isStatic(SgDynamicConfiguration<?> configuration, String resourceName) {
        Object o = configuration.getCEntry(resourceName);
        return o != null && o instanceof StaticDefinable && ((StaticDefinable)o).isStatic();
    }

    protected void consumeParameters(RestRequest request) {
        request.param("name");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected abstract Endpoint getEndpoint();

    private <T> void logComplianceEvent(SgDynamicConfiguration<T> result) {
        ImmutableMap fields = ImmutableMap.of((Object)result.getCType().toLCString(), (Object)Strings.toString(result));
        this.auditLog.logDocumentRead(this.cl.getEffectiveSearchGuardIndex(), result.getCType().toLCString(), null, (Map)fields);
    }

    private static class ConfigUpdatingActionListener<Response>
    implements ActionListener<Response> {
        private final Client client;
        private final ActionListener<Response> delegate;

        public ConfigUpdatingActionListener(Client client, ActionListener<Response> delegate) {
            this.client = client;
            this.delegate = delegate;
        }

        public void onResponse(final Response response) {
            ConfigUpdateRequest cur = new ConfigUpdateRequest(CType.lcStringValues().toArray(new String[0]));
            this.client.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)cur, (ActionListener)new ActionListener<ConfigUpdateResponse>(){

                public void onResponse(ConfigUpdateResponse ur) {
                    if (ur.hasFailures()) {
                        delegate.onFailure((Exception)ur.failures().get(0));
                        return;
                    }
                    delegate.onResponse(response);
                }

                public void onFailure(Exception e) {
                    delegate.onFailure(e);
                }
            });
        }

        public void onFailure(Exception e) {
            this.delegate.onFailure(e);
        }
    }

    abstract class OnSucessActionListener<Response>
    implements ActionListener<Response> {
        private final RestChannel channel;

        public OnSucessActionListener(RestChannel channel) {
            this.channel = channel;
        }

        public final void onFailure(Exception e) {
            AbstractApiAction.this.internalErrorResponse(this.channel, "Error " + e.getMessage());
        }
    }
}

